libname nsf4 'C:\DATA\NSF4\SAS';
libname out 'C:\DATA\NSF4\SAS\outv3linear';
options nofmterr compress=yes;


*** NSF4 Layout Experiment ***;
*** Andy Peytchev ***;

proc contents data=nsf4.nsf4_ce_data_2_16_05 varnum; run;

proc freq data=nsf4.nsf4_ce_data_2_16_05;
*format _numeric_;
tables cmpt q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
run;

data temp (compress=no);
      set nsf4.nsf4_ce_data_2_16_05;

      *if cmpt=1;  *keep only completes;

      *** get rid of missing values - need to comment this out for analysis of missing values;
      array MISSarray (*) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4
                                    q11 q11r q89a q89b q90 q87 q88 q92 q94-q103 q107
                                    q1 q2 q3 q4 q5 q6 q7 q8
                                    q12 q13 q14 q15
                                    q16 q17 q18 q19
                                    q20 q21 q22 q23
                                    q27a q27b q27c q27d q27e q27f q27g q27h;
      do i=1 to dim(MISSarray);
            if MISSarray(i)=-3 then MISSarray(i)=.;
      end;
      if q89a=777 and q89b=777 and q90=300 then q90=.; *remove one goofy case;
      if q90<50 or q90>500 then q90=.; ** a few cases with impossible weight reported;
      if q89a<3 or q89a>8 then q89a=.; ** a few cases with impossible height reported;
      if q89b>12 then q89b=.; ** a few cases with impossible height reported;
      ** indicator whether all 6 questions were answered;
      q10miss_ind=1;
      array q10array (*) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
      do i=1 to dim(q10array);
            if q10array(i)<1 then q10miss_ind=0;
      end;
      q10d3r=8-q10d3;
      q10d4r=8-q10d4;

      cmpt2=0; *whether the respondent completed the experiment;
      if exp3l=1 then do;
            if STMQ12>0 then cmpt2=1;
      end;
      if exp3l=2 then do;
            if STMQ11>0 then cmpt2=1;
      end;

      cmpt3=0;
      if stmQ38>0 then cmpt3=1;

      if cmpt3=1; * keep only those who started Q38 - retains 70 cases that broke off after the experiments;

      ** Collapsing Independent Instructions with No Instructions in EXP3B;
      exp3br=exp3b;
      if exp3br=3 then exp3br=2;

      ******************* OUTCOME MEASURES *********************************;
      ** reversing q11;
      q11r=8-q11;
      if q11=-3 then q11r=-3;
      ************ STDDEV of the 8 items;
      if q10miss_ind=1
            then q10stddev=std(q10d1, q10d2, q10d4, q10e1, q10e2, q10e4);
      ************ Average STDDEV of both sets of 4 items;
      if q10miss_ind=1
            then q10avgstddev=(std(q10d1, q10d2, q10d4r) + std(q10e1, q10e2, q10e4))/2;
      ************ FOLDED response scales - 0=Neither, 3=Far (more/less);
      *array q10array (8) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
      array q10arrayFold (*) q10d1fold q10d2fold  q10d4fold
                                          q10e1fold q10e2fold  q10e4fold;
      do i=1 to dim(q10arrayFold);
            q10arrayFold(i)=q10array(i)-4; *make the scale -3 to 3;
            if q10arrayFold(i)<0 and q10arrayFold(i)>=-3
                  then q10arrayFold(i)=q10arrayFold(i)*-1; *fold by making positive;
      end;
      ************ BMI;
      ** formula from CDC:
      ** BMI = ( Weight in Pounds / ((Height in inches) x (Height in inches)) ) x 703 ;
      BMI=(q90/((q89a*12+q89b)*(q89a*12+q89b)))*703;
      ************* number of item-missing (0-8) for each question;
      if cmpt=1 then q10misscount=0; *if completed the experimental qns, set missing counter to 0;
      do i=1 to dim(q10array);
            if q10array(i)=.d then q10misscount=q10misscount+1;
      end;
      q10missindicator=q10misscount;
      if q10misscount>0 then q10missindicator=1;
      *** NOTHING (10-7-5 for diff-same&separate-grid) by breakoff on q10;
      /*q10breakoff=0;
      if stmq10d1>0 and etmq10e4<0 then q10breakoff=1;
      else if stmq10v2>0 and etmq10v2<0 then q10breakoff=1;*/
      run;
proc format;
value exp3l 1='Early' 2='Late';
value exp3a 1='Different Pages' 2='Same Page,  Separate' 3='Same Page, Grid';
value exp3b 1='Related' 2='Independent' 3='None';
value exp3br 1='Related' 2='Independent or None';
value exp3c 1='By topic' 2='Mixed';
run;



** drop 1/3 of cases that are asked early, to simulate split questionnaire design alternative;
proc sort data=temp;
by id;
run;
data temp;
        set temp;
      randomnum=ranuni(850); *seed=850;
proc sort data=temp;
by randomnum;
data temp;
      set temp;
      retain j;
      if _N_=1 then j=1;
      if _N_>1 then j=j+1;
      if j=4 then j=1;
run;





data temp2 (drop=cmpt i itemnrflag q89a q89b);
        set temp (keep = ID sample cmpt j
                q10d1 q10d2  q10d4 q10e1 q10e2  q10e4
                q11r q89a q89b q90 q87 q88 q92 q94-q103 q107
                exp1L exp1P exp2a
                exp3l exp3a exp3b exp3c
                exp4a exp4b exp4c
                exp5a exp5b exp5c
                q1 q2 q3 q4 q5 q6 q7 q8 q12 q13 q14 q15
                q16 q17 q18 q19
                q20 q21 q22 q23
                q27a q27b q27c q27d q27e q27f q27g q27h);

        if exp3l=2 then j=0;

        if exp3a=1; * separate pages;

        if cmpt;

        array q10array (*) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;

        itemnrflag=0;
        do i=1 to dim(q10array);
                if q10array(i)<1 then itemnrflag=1; * drop all cases with item nonresponse;
        end;

        if itemNRflag=0;

        if q89a=8 then q89a=.; * 8 feet height;

        if q89a>=4 and q89b>=0 then height= q89a*12 + q89b ;

        BMI=(q90/(height*height))*703;

        if BMI>0;
        if q87>=0; * gender;
        if q88>0; * age;
run;
data tempforimputation (drop = i height q90 j); * delete all values when the qns appear late;
        set temp2;
        if exp3l=1; *keep only early condition cases;
        array q10array (*) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
        if exp3l=1 and j=3 then do; * early and 1/3 of cases;
                do i=1 to dim(q10array);
                        q10array(i)=.;
                end;
        end;
data early (where=(exp3l=1)) late (where=(exp3l=2)) earlyANDlate (where=(exp3l in(1,2)));
        set temp2;
run;


proc freq data=tempforimputation;
tables /*itemnrflag*exp3l q89a q89b q90*/ BMI ;
run;

%IMPUTE (NAME=MYSETUP,DIR=C:\TEMP,SETUP=NEW);
DATAIN tempforimputation;
DATAOUT tempimputed CON;
DEFAULT Categorical;
*CATEGORICAL sample
                q10d1 q10d2  q10d4 q10e1 q10e2  q10e4
                q11r q87 q88 q92 q94-q103 q107
                exp1L exp1P exp2a
                exp3l exp3a exp3b exp3c
                exp4a exp4b exp4c
                exp5a exp5b exp5c;
CONTINUOUS      BMI
                q1 q2 q3 q4 q5 q6 q7 q8 q11r q12 q13 q14 q15
                q16 q17 q18 q19
                q20 q21 q22 q23
                q27a q27b q27c q27d q27e q27f q27g q27h
                q103 q88
                 q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
TRANSFER        ID exp3a exp3l;
BOUNDS          BMI(>=16.139,<=55.378)
                q1(>=1,<=10)
                q2(>=1,<=10)
                q3(>=1,<=7)
                q4(>=1,<=7)
                q5(>=1,<=7)
                q6(>=1,<=7)
                q7(>=1,<=7)
                q8(>=1,<=7)
                q10d1(>=1,<=7)
                q10d2(>=1,<=7)
                q10d4(>=1,<=7)
                q10e1(>=1,<=7)
                q10e2(>=1,<=7)
                q10e4(>=1,<=7)
                q11r(>=1,<=7)
                q12(>=1,<=11)
                q13(>=1,<=11)
                q14(>=1,<=11)
                q15(>=1,<=11)
                q16(>=1,<=7)
                q17(>=1,<=7)
                q18(>=1,<=7)
                q19(>=1,<=7)
                q20(>=1,<=7)
                q21(>=1,<=7)
                q22(>=1,<=7)
                q23(>=1,<=7)
                q27a(>=1,<=5)
                q27b(>=1,<=5)
                q27c(>=1,<=5)
                q27d(>=1,<=5)
                q27e(>=1,<=5)
                q27f(>=1,<=5)
                q27g(>=1,<=5)
                q27h(>=1,<=5)
                q103(>=1,<=7);
INTERACT        BMI *       q10d1
                BMI *       q10d2
                BMI *       q10d4
                BMI *       q10e1
                BMI *       q10e2
                BMI *       q10e4;
*MINRSQD .005;
ITERATIONS 3;
MULTIPLES 25;
SEED 666;
RUN;



data out.nsf1      (where=(_mult_=1))
out.nsf2      (where=(_mult_=2))
out.nsf3      (where=(_mult_=3))
out.nsf4      (where=(_mult_=4))
out.nsf5      (where=(_mult_=5))
out.nsf6      (where=(_mult_=6))
out.nsf7      (where=(_mult_=7))
out.nsf8      (where=(_mult_=8))
out.nsf9      (where=(_mult_=9))
out.nsf10      (where=(_mult_=10))
out.nsf11      (where=(_mult_=11))
out.nsf12      (where=(_mult_=12))
out.nsf13      (where=(_mult_=13))
out.nsf14      (where=(_mult_=14))
out.nsf15      (where=(_mult_=15))
out.nsf16      (where=(_mult_=16))
out.nsf17      (where=(_mult_=17))
out.nsf18      (where=(_mult_=18))
out.nsf19      (where=(_mult_=19))
out.nsf20      (where=(_mult_=20))
out.nsf21      (where=(_mult_=21))
out.nsf22      (where=(_mult_=22))
out.nsf23      (where=(_mult_=23))
out.nsf24      (where=(_mult_=24))
out.nsf25      (where=(_mult_=25));
        set tempimputed ;
        *BMI=(q90/(height*height))*703;
run;

%MACRO addvars(indata, outdata);
   data &outdata;
      set &indata;
      q10miss_ind=0;
          q10middleoption=0;
      array q10array (*) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
      do i=1 to dim(q10array);
            if q10array(i)<1 then q10miss_ind=1;
            if q10array(i)=4 then q10middleoption=1;
      end;
      q10d4r=8-q10d4;
          ************ middle option use;
          if q10miss_ind=1 then q10middleoption=.;
      ************ STDDEV of the 8 items;
      if q10miss_ind=0
            then q10stddev=std(q10d1, q10d2, q10d4, q10e1, q10e2, q10e4);
      if q10miss_ind=0
            then q10stddevR=std(q10d1, q10d2, q10d4r, q10e1, q10e2, q10e4);
      ************ Average STDDEV of both sets of 4 items;
      if q10miss_ind=0
            then q10AVGstddev=(std(q10d1, q10d2, q10d4) + std(q10e1, q10e2, q10e4))/2;
      if q10miss_ind=0
            then q10AVGstddevR=(std(q10d1, q10d2, q10d4r) + std(q10e1, q10e2, q10e4))/2;
      ************ STDDEV of both sets of 3 items;
      if q10miss_ind=0 then do;
            q10Dstddev=std(q10d1, q10d2, q10d4);
            q10DstddevR=std(q10d1, q10d2, q10d4r);
            q10Estddev=std(q10e1, q10e2, q10e4);
      end;
   run;
%MEND;

%addvars(early, out.early);
%addvars(late, out.late);
%addvars(earlyANDlate, out.earlyANDlate);
%addvars(tempforimputation, out.tempforimputation);
run;

%MACRO loopimp;
        %do i=1 %to 25;
        %addvars(out.nsf&i,out.nsf&i);
        %end;
        run;
%MEND;
%loopimp;
run;



*Get standard deviations;
data imputedconcat;
        set out.nsf1      out.nsf2      out.nsf3      out.nsf4      out.nsf5
                out.nsf6      out.nsf7      out.nsf8      out.nsf9      out.nsf10
                out.nsf11      out.nsf12      out.nsf13      out.nsf14      out.nsf15
                out.nsf16      out.nsf17      out.nsf18      out.nsf19      out.nsf20
                out.nsf21      out.nsf22      out.nsf23      out.nsf24      out.nsf25;
run;

proc means data=out.early mean stddev var ;
var q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
output out=stddevearly var= ;

proc means data=out.late mean var ;
var q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
output out=stddevlate var= ;

proc means data=imputedconcat  mean var;
var q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
by _mult_;
output out=stddevimp var= ;

proc means data=stddevimp mean;
var q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
output out=stddevimp mean= ;

data combinedstddevs (drop=_freq_ _type_);
        set stddevearly (in=i) stddevlate (in=ii) stddevimp (in=iii);
        if i then scenario='Early  ';
        if ii then scenario='Late   ';
        if iii then scenario='Imputed';
        array q10var (6) q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
        array q10std (6) q10d1std q10d2std  q10d4std q10e1std q10e2std  q10e4std;
        do i=1 to 6;
                q10std(i)=sqrt(q10var(i));
        end;

proc transpose data=combinedstddevs out=combinedstddevstran;
id scenario;

proc export data=combinedstddevstran outfile='C:\DATA\NSF4\SAS\outv3linear\stddevs.xls' dbms = xls replace;
run;




ods html file='C:\DATA\NSF4\SAS\outv3linear\EarlyCondition.xls' style=minimal;
%describe (SETUP=NEW, NAME=desSETUP, DIR=C:\TEMP);
title           early condition;
DATAIN          out.early;
MEAN            q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  q10avgstddevR q10dstddev q10dstddevR q10estddev q10middleoption;
run;
ods html close;

ods html file='C:\DATA\NSF4\SAS\outv3linear\LateCondition.xls' style=minimal;
%describe (SETUP=NEW, NAME=desSETUP, DIR=C:\TEMP);
title           late condition;
DATAIN          out.late;
MEAN            q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  q10avgstddevR q10dstddev q10dstddevR q10estddev q10middleoption;
run;
ods html close;

ods html file='C:\DATA\NSF4\SAS\outv3linear\HalfImputedEarly.xls' style=minimal;
%describe (SETUP=NEW, NAME=desSETUP, DIR=C:\TEMP);
title           imputed;
DATAIN          out.nsf1      out.nsf2      out.nsf3      out.nsf4      out.nsf5
                out.nsf6      out.nsf7      out.nsf8      out.nsf9      out.nsf10
                out.nsf11      out.nsf12      out.nsf13      out.nsf14      out.nsf15
                out.nsf16      out.nsf17      out.nsf18      out.nsf19      out.nsf20
                out.nsf21      out.nsf22      out.nsf23      out.nsf24      out.nsf25 ;
MEAN            q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  q10avgstddevR q10dstddev q10dstddevR q10estddev q10middleoption;
run;
ods html close;

ods html file='C:\DATA\NSF4\SAS\outv3linear\PriorToImputation.xls' style=minimal;
%describe (SETUP=NEW, NAME=desSETUP, DIR=C:\TEMP);
title           late condition;
DATAIN          out.tempforimputation;
MEAN            q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  q10avgstddevR q10dstddev q10dstddevR q10estddev q10middleoption;
run;
ods html close;






%REGRESS (SETUP=NEW, NAME=REGSETUP, DIR=C:\TEMP);
title           BMI - early condition;
DATAIN          out.early;
CATEGORICAL     q87 /*gender*/ q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
DEPENDENT       BMI;
PREDICTOR       q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  /*q87 q88*/;
ID              id;
run;


%REGRESS (SETUP=NEW, NAME=REGSETUP, DIR=C:\TEMP);
title           BMI - late condition;
DATAIN          out.late;
CATEGORICAL     q87 /*gender*/ q10d1 q10d2  q10d4 q10e1 q10e2  q10e4;
DEPENDENT       BMI;
PREDICTOR       q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  /*q87 q88*/;
ID              id;
run;


%REGRESS (SETUP=NEW, NAME=REGSETUP, DIR=C:\TEMP);
title           BMI - half-imputed early condition;
DATAIN          out.nsf1      out.nsf2      out.nsf3      out.nsf4      out.nsf5
                out.nsf6      out.nsf7      out.nsf8      out.nsf9      out.nsf10
                out.nsf11      out.nsf12      out.nsf13      out.nsf14      out.nsf15
                out.nsf16      out.nsf17      out.nsf18      out.nsf19      out.nsf20
                out.nsf21      out.nsf22      out.nsf23      out.nsf24      out.nsf25 ;
CATEGORICAL     q87 /*gender*/ /*q10d1 q10d2  q10d4 q10e1 q10e2  q10e4*/;
DEPENDENT       BMI;
PREDICTOR       q10d1 q10d2  q10d4 q10e1 q10e2  q10e4  /*q87 q88*/;
ID              id;
run;








%macro arrays;
  %do i=1 %to 25;
data early2 (keep=id origq10d1 origq10d2 origq10d4 origq10e1 origq10e2 origq10e4);
        set out.early;
array old (6) q10d1 q10d2 q10d4 q10e1 q10e2 q10e4;
array renamed (6) origq10d1 origq10d2 origq10d4 origq10e1 origq10e2 origq10e4;
do i=1 to 6;
      renamed(i)=old(i);
end;
proc sort data=out.nsf&i out=nsf&i;
by id;
proc sort data=early2;
by id;
DATA nsf&i;
        merge nsf&i (in=i) early2;
        by id;
            if i;
array imput (6) q10d1 q10d2 q10d4 q10e1 q10e2 q10e4;
array goldstd (6) origq10d1 origq10d2 origq10d4 origq10e1 origq10e2 origq10e4;
array bias (6) biasq10d1 biasq10d2 biasq10d4 biasq10e1 biasq10e2 biasq10e4;
do j=1 to 6;
      bias(j)=imput(j)-goldstd(j);
end;
run;
  %END;
%MEND arrays;
%arrays;


ods html file='C:\DATA\NSF4\SAS\outv3linear\stderr_of_bias_in_imputed.xls' style=minimal;
%describe (SETUP=NEW, NAME=desSETUP, DIR=C:\TEMP);
title           imputed;
DATAIN          nsf1      nsf2      nsf3      nsf4      nsf5
                nsf6      nsf7      nsf8      nsf9      nsf10
                nsf11      nsf12      nsf13      nsf14      nsf15
                nsf16      nsf17      nsf18      nsf19      nsf20
                nsf21      nsf22      nsf23      nsf24      nsf25 ;
MEAN            biasq10d1 biasq10d2  biasq10d4 biasq10e1 biasq10e2  biasq10e4  ;
run;
ods html close;
* std error of bias in fully observed uses the sqrt of the sum of the two variances, since separate samples;




* Correlations;
* http://support.sas.com/documentation/cdl/en/statug/63347/HTML/default/viewer.htm#statug_mianalyze_sect028.htm ;
proc corr data=early fisher(biasadj=no);
        title 'Early';
        var q10d1 q10d4;
run;

proc corr data=late fisher(biasadj=no);
        title 'Late';
        var q10d1 q10d4;
run;

data nsfconcat;
      set       out.nsf1      out.nsf2      out.nsf3      out.nsf4      out.nsf5
                out.nsf6      out.nsf7      out.nsf8      out.nsf9      out.nsf10
                out.nsf11      out.nsf12      out.nsf13      out.nsf14      out.nsf15
                out.nsf16      out.nsf17      out.nsf18      out.nsf19      out.nsf20
                out.nsf21      out.nsf22      out.nsf23      out.nsf24      out.nsf25;
run;
proc corr data=nsfconcat fisher(biasadj=no);
   var q10d1 q10d4;
   by _mult_;
   ods output FisherPearsonCorr= outz;
run;
data outz;
   set outz;
   StdZ= 1. / sqrt(NObs-3);
run;
proc mianalyze data=outz;
   title 'Imputed';
   ods output ParameterEstimates=parms;
   modeleffects ZVal;
   stderr StdZ;
run;
data corr_ci;
   set parms;
   r=       tanh( Estimate);
   r_lower= tanh( LCLMean);
   r_upper= tanh( UCLMean);
run;
proc print data=corr_ci;
   title 'Estimated Correlation Coefficient'
         ' with 95% Confidence Limits';
   var r r_lower r_upper;
run;



** descriptives for paper - time - early vs late appearance in the questionnaire;
data time;
        set temp;
        if begtime>0 then do;
                begtimeChar=put(begtime,best6.);
                begtimeSeconds=60*60*substr(right(begtimeChar),1,2)+60*substr(right(begtimeChar),3,2)+1*substr(right(begtimeChar),5,2);
        end;
        if stmq10d1>0 then do;
                stmq10Char=put(stmq10d1,best6.);
                stmq10Seconds=60*60*substr(right(stmq10Char),1,2)+60*substr(right(stmq10Char),3,2)+1*substr(right(stmq10Char),5,2);
        end;
        else if stmq10v2>0 then do;
                stmq10Char=put(stmq10v2,best6.);
                stmq10Seconds=60*60*substr(right(stmq10Char),1,2)+60*substr(right(stmq10Char),3,2)+1*substr(right(stmq10Char),5,2);
        end;
        locationofexp=stmq10Seconds-begtimeSeconds;
        if .<locationofexp<0 then locationofexp=locationofexp*12*60*60; *if over midnight, add seconds for 24hrs;
        locationofexpminutes=locationofexp/60;

        if cmpt;

        if locationofexpminutes<60; *drop 12 cases with time greater than 1 hour;
run;
proc freq;
table locationofexpminutes;
run;
proc means data=time min max mean stderr;
class exp3l;
var locationofexpminutes;
run;
